<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!-- 
####################################################################################
#  XSL name : section5
#  Version : R2.0.8.S04                                        
#  Intermediate release number : 036-20200706                                 
#  Last update : 09/12/2019                                                            
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
	<!-- -->
	<xsl:template match="*[@FORM='18']//AWARD_OF_CONTRACT_DEFENCE[not(CONTRACT_AWARD_DATE)]|*[@FORM='3']//AWARD_OF_CONTRACT[not(CONTRACT_AWARD_DATE)] | *[@FORM='6']//AWARD_AND_CONTRACT_VALUE[not(DATE_OF_CONTRACT_AWARD)] | *[@FORM='6'][not(.//AWARD_AND_CONTRACT_VALUE)]" mode="R215">
		<xsl:variable name="ele">
			<xsl:choose>
				<xsl:when test="ancestor::*/@FORM='3'">AWARD_OF_CONTRACT/CONTRACT_AWARD_DATE</xsl:when>
				<xsl:when test="ancestor::*/@FORM='18'">AWARD_OF_CONTRACT_DEFENCE[<xsl:value-of select="@ITEM"/>]/CONTRACT_AWARD_DATE</xsl:when>
				<xsl:otherwise>DATE_OF_CONTRACT_AWARD</xsl:otherwise>
			</xsl:choose> missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R215'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R215"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R215"/>
	<xsl:template match="@*|node()" priority="-2" mode="R215">
		<xsl:apply-templates select="@*|*" mode="R215"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='13'][.//RESULT_CONTEST[not(.//PARTICIPANTS_NUMBER[number()>0])]]" mode="R216">
		<xsl:variable name="ele">PARTICIPANTS_NUMBER missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R216'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R216"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R216"/>
	<xsl:template match="@*|node()" priority="-2" mode="R216">
		<xsl:apply-templates select="@*|*" mode="R216"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='13'][.//RESULT_CONTEST[not(.//FOREIGN_PARTICIPANTS_NUMBER)]]" mode="R217">
		<xsl:variable name="ele">FOREIGN_PARTICIPANTS_NUMBER missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R217'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R217"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R217"/>
	<xsl:template match="@*|node()" priority="-2" mode="R217">
		<xsl:apply-templates select="@*|*" mode="R217"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='13']//RESULT_CONTEST" mode="R218">
		<xsl:choose>
			<xsl:when test="descendant::OFFICIALNAME[matches(text() ,'[\p{L}\p{N}]+')] and 
                descendant::ADDRESS[matches(text() ,'[\p{L}\p{N}]+')] and 
                descendant::TOWN[matches(text() ,'[\p{L}\p{N}]+')] and 
                descendant::EMAIL"/>
			<xsl:otherwise>
				<xsl:variable name="ele">NAME_ADDRESS_WINNER missing/incomplete</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R218'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R218"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R218"/>
	<xsl:template match="@*|node()" priority="-2" mode="R218">
		<xsl:apply-templates select="@*|*" mode="R218"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='18']//AWARD_OF_CONTRACT_DEFENCE[not(OFFERS_RECEIVED_NUMBER) or (number(OFFERS_RECEIVED_NUMBER)&lt;1)] |*[@FORM='3']//AWARD_OF_CONTRACT[not(OFFERS_RECEIVED_NUMBER)] | *[@FORM='6']//AWARD_AND_CONTRACT_VALUE[not(OFFERS_RECEIVED_NUMBER)] | *[@FORM='6'][not(.//AWARD_AND_CONTRACT_VALUE)]" mode="R219">
		<xsl:variable name="ele">
			<xsl:choose>
				<xsl:when test="ancestor::*/@FORM='3'">AWARD_OF_CONTRACT/</xsl:when>
				<xsl:when test="ancestor::*/@FORM='18'">AWARD_OF_CONTRACT_DEFENCE[<xsl:value-of select="@ITEM"/>]/</xsl:when>
				<xsl:otherwise>AWARD_AND_CONTRACT_VALUE/</xsl:otherwise>
			</xsl:choose>OFFERS_RECEIVED_NUMBER missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R219'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R219"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R219"/>
	<xsl:template match="@*|node()" priority="-2" mode="R219">
		<xsl:apply-templates select="@*|*" mode="R219"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='18']//AWARD_OF_CONTRACT_DEFENCE|*[@FORM='3']//AWARD_OF_CONTRACT | *[@FORM='6']//AWARD_AND_CONTRACT_VALUE | *[@FORM='15']//AWARD_OF_CONTRACT_DEFENCE" mode="R220">
		<xsl:choose>
			<xsl:when test="descendant::OFFICIALNAME[matches(text() ,'[\p{L}\p{N}]+')] and 
			 descendant::TOWN[matches(text() ,'[\p{L}\p{N}]+')] and 
                descendant::COUNTRY"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="//@FORM='6'">AWARD_AND_CONTRACT_VALUE[.//OFFICIALNAME, .//TOWN, .//COUNTRY]</xsl:when>
						<xsl:when test="//@FORM='18'">AWARD_OF_CONTRACT_DEFENCE[<xsl:value-of select="@ITEM"/>]/ECONOMIC_OPERATOR_NAME_ADDRESS[.//OFFICIALNAME, .//TOWN, .//COUNTRY]</xsl:when>
						<xsl:otherwise>AWARD_OF_CONTRACT/ECONOMIC_OPERATOR_NAME_ADDRESS</xsl:otherwise>
					</xsl:choose> missing/incomplete</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R220'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R220"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='6'][not(.//AWARD_AND_CONTRACT_VALUE)]" mode="R220">
		<xsl:variable name="ele">AWARD_AND_CONTRACT_VALUE/CONTACT_DATA_WITHOUT_RESPONSIBLE_NAME_CHP missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R220'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R220"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R220"/>
	<xsl:template match="@*|node()" priority="-2" mode="R220">
		<xsl:apply-templates select="@*|*" mode="R220"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='3']//AWARD_OF_CONTRACT" mode="R222">
		<xsl:choose>
			<xsl:when test=".//NO_CONTRACT_LIKELY_SUB_CONTRACTED"/>
			<xsl:when test=".//EXCLUDING_VAT_VALUE|.//EXCLUDING_VAT_PRCT|.//UNKNOWN_VALUE"/>
			<xsl:otherwise>
				<xsl:variable name="ele">NO_CONTRACT_LIKELY_SUB_CONTRACTED or CONTRACT_LIKELY_SUB_CONTRACTED/* missing/incomplete</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R222'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R222"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R222"/>
	<xsl:template match="@*|node()" priority="-2" mode="R222">
		<xsl:apply-templates select="@*|*" mode="R222"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='6']//AWARD_AND_CONTRACT_VALUE[not(NO_CONTRACT_LIKELY_SUB_CONTRACTED or CONTRACT_LIKELY_SUB_CONTRACTED)] | *[@FORM='6'][not(.//AWARD_AND_CONTRACT_VALUE)]" mode="R223">
		<xsl:variable name="ele">(NO_)CONTRACT_LIKELY_SUB_CONTRACTED missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R223'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R223"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R223"/>
	<xsl:template match="@*|node()" priority="-2" mode="R223">
		<xsl:apply-templates select="@*|*" mode="R223"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='6']//MANDATORY_INFORMATION_NOT_INTENDED_PUBLICATION[not(NUMBER_CONTRACTS_AWARDED)] | *[@FORM='6'][not(.//MANDATORY_INFORMATION_NOT_INTENDED_PUBLICATION)]" mode="R224">
		<xsl:variable name="ele">NUMBER_CONTRACTS_AWARDED missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R224'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R224"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R224"/>
	<xsl:template match="@*|node()" priority="-2" mode="R224">
		<xsl:apply-templates select="@*|*" mode="R224"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='6']//MANDATORY_INFORMATION_NOT_INTENDED_PUBLICATION[not(.//VALUE_COST)] | *[@FORM='6'][not(.//MANDATORY_INFORMATION_NOT_INTENDED_PUBLICATION)]" mode="R225">
		<xsl:variable name="ele">VALUE_COST missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R225'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R225"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R225"/>
	<xsl:template match="@*|node()" priority="-2" mode="R225">
		<xsl:apply-templates select="@*|*" mode="R225"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='6']//MANDATORY_INFORMATION_NOT_INTENDED_PUBLICATION[not(.//COMMUNITY_ORIGIN | .//NO_COMMUNITY_ORIGIN)] | *[@FORM='6'][not(.//MANDATORY_INFORMATION_NOT_INTENDED_PUBLICATION)]" mode="R226">
		<xsl:variable name="ele">(NO_)COMMUNITY_ORIGIN missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R226'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R226"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R226"/>
	<xsl:template match="@*|node()" priority="-2" mode="R226">
		<xsl:apply-templates select="@*|*" mode="R226"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='6']//MANDATORY_INFORMATION_NOT_INTENDED_PUBLICATION[not(PRICE_AWARD_CRITERIA)] | *[@FORM='6'][not(.//MANDATORY_INFORMATION_NOT_INTENDED_PUBLICATION)]" mode="R227">
		<xsl:variable name="ele">PRICE_AWARD_CRITERIA/@PRICE missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R227'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R227"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R227"/>
	<xsl:template match="@*|node()" priority="-2" mode="R227">
		<xsl:apply-templates select="@*|*" mode="R227"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='6']//MANDATORY_INFORMATION_NOT_INTENDED_PUBLICATION[not(CONTRACT_AWARDED|NO_CONTRACT_AWARDED)] | *[@FORM='6'][not(.//MANDATORY_INFORMATION_NOT_INTENDED_PUBLICATION)]" mode="R228">
		<xsl:variable name="ele">(NO_)CONTRACT_AWARDED missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R228'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R228"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R228"/>
	<xsl:template match="@*|node()" priority="-2" mode="R228">
		<xsl:apply-templates select="@*|*" mode="R228"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='6']//MANDATORY_INFORMATION_NOT_INTENDED_PUBLICATION[not(TENDERS_EXCLUDED|NO_TENDERS_EXCLUDED)] | *[@FORM='6'][not(.//MANDATORY_INFORMATION_NOT_INTENDED_PUBLICATION)]" mode="R229">
		<xsl:variable name="ele">(NO_)TENDERS_EXCLUDED missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R229'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R229"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R229"/>
	<xsl:template match="@*|node()" priority="-2" mode="R229">
		<xsl:apply-templates select="@*|*" mode="R229"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='15'][ not(.//@NOTICE='CONTRACTING_DEFENCE')][ .//SUBCONTRACT_DEFENCE/*]" mode="R230">
		<xsl:variable name="ele">@NOTICE='<xsl:value-of select=".//@NOTICE"/>' and <xsl:value-of select="local-name( .//SUBCONTRACT_AWARD_PART)"/>,<xsl:value-of select="local-name( .//SUBCONTRACT_SHARE)"/> inconsistent</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R230'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R230"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R230"/>
	<xsl:template match="@*|node()" priority="-2" mode="R230">
		<xsl:apply-templates select="@*|*" mode="R230"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='18']//AWARD_OF_CONTRACT_DEFENCE[not(.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE[.//VALUE_COST or .//LOW_VALUE])]" mode="R250">
		<xsl:variable name="ele">AWARD_OF_CONTRACT_DEFENCE[<xsl:value-of select="@ITEM"/>]/CONTRACT_VALUE_INFORMATION/COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE[VALUE_COST or RANGE_VALUE_COST] missing</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R250'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R250"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R250"/>
	<xsl:template match="@*|node()" priority="-2" mode="R250">
		<xsl:apply-templates select="@*|*" mode="R250"/>
	</xsl:template>
	<!---->
	<xsl:template match="AWARD_OF_CONTRACT_DEFENCE[.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE/VALUE_COST]" mode="R619">
		<xsl:choose>
			<xsl:when test="not(ancestor::*[@FORM]//TOTAL_FINAL_VALUE//VALUE_COST)"/>
			<xsl:when test="ancestor::*[@FORM]//TOTAL_FINAL_VALUE//@CURRENCY !=.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE/@CURRENCY"/>
			<xsl:when test="
			count(ancestor::*[@FORM]//TOTAL_FINAL_VALUE//*[matches(local-name(), '_VAT$')])!=
			count(.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE/*[matches(local-name(), '_VAT$')])"/>
			<xsl:when test="
			ancestor::*[@FORM]//TOTAL_FINAL_VALUE//*[matches(local-name(), '_VAT$')]/local-name()!=
			.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE/*[matches(local-name(), '_VAT$')]/local-name()"/>
			<xsl:when test="
			ancestor::*[@FORM]//TOTAL_FINAL_VALUE//VALUE_COST/number()>=.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE/VALUE_COST/number()"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('TOTAL_FINAL_VALUE[VALUE_COST = ',	
				ancestor::*[@FORM]//TOTAL_FINAL_VALUE//VALUE_COST/text(),' ',
				ancestor::*[@FORM]//TOTAL_FINAL_VALUE//@CURRENCY,
				'] and AWARD_OF_CONTRACT_DEFENCE[',./@ITEM,'][VALUE_COST = ',
				.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE/VALUE_COST/text(),' ',
				.//COSTS_RANGE_AND_CURRENCY_WITH_VAT_RATE//@CURRENCY,']')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R619'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
				<xsl:apply-templates select="@*|*" mode="R619"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R619"/>
	<xsl:template match="@*|node()" priority="-2" mode="R619">
		<xsl:apply-templates select="@*|*" mode="R619"/>
	</xsl:template>
</xsl:stylesheet>
